﻿using System;
using System.Collections.Generic;
using System.Text;
using Newtonsoft.Json;
using System.Net.Http;

namespace DeXGets
{
    public class BaseClass
    {
        public string ErrorMessage = "";
        protected class ODataResponse<T>
        {
            public List<T> Value { get; set; }
            [JsonProperty("@odata.context")]
            public string Context;
            [JsonProperty("@odata.nextLink")]
            public string NextLink;
        }
        protected static string DoCall(string URL, string BearerToken, HttpClient _httpClient, string SubscriptionKey)
        {
            string resp = "";
            try
            {
                PostitCommon.Call c = new PostitCommon.Call(URL);
                // Execute the call
                // Passes in the bearer token and the subscription key
                resp = c.Execute(BearerToken, _httpClient, SubscriptionKey);
            }
            catch
            {

            }
            return resp;
        }
        protected static string SetURL(string Service, string Call)
        {
            bool Dex = false;
            string URLBase = "https://seli00apm01.azure-api.net/dex//";
            if (Dex)
            {
                // <Base>\staff/odata/v3/StaffPersonalBasics
                return URLBase + string.Format("{0}/odata/V3/{1}", Service, Call);
            }
            URLBase = "https://seli00apm01.azure-api.net/ssli01/";
            // <Base>\staff/odata/v3/StaffPersonalBasics
            return URLBase + string.Format("{0}/V3/{1}", Service, Call);
        }
    
        /// <summary>
        /// This function is included to get around an initial bug 
        /// however, once fixed the 'bad' url won't occur and 
        /// </summary>
        /// <param name="nextLink"></param>
        /// <returns></returns>
        protected static string GetNextLink(string nextLink)
        {
            string bad = "https://sims8live01.westeurope.cloudapp.azure.com:8443";
            if (nextLink.StartsWith(bad))
            {
                string[] bits = nextLink.Split('/');
                string service = bits[3].Substring(0, bits[3].IndexOf("servicefarm1"));
                string call = bits[6];

                //https://sims8live01.westeurope.cloudapp.azure.com:8443/learnerservicefarm1/odata/v3/LearnerPersonals?$select=ExternalID%2CDateOfBirth&$skip=1000
                // https://seli00apm01.azure-api.net/dex/Learner/odata/V3/LearnerPersonals?$select=ExternalID,DateOfBirth
                // https://seli00apm01.azure-api.net/dex/learnerservicefarm1/odata/v3/LearnerPersonals?$select=ExternalID%2CDateOfBirth&$skip=1000
                // https://seli00apm01.azure-api.net/dex/learnerservicefarm1/odata/v3/LearnerPersonals?$select=ExternalID%2CDateOfBirth&$skip=1000
                string s = SetURL(service, call);
                return s;
            }
            return nextLink;
        }

    }
}
